//
//  TWListNavigationController.m
//  Twitch Plugin
//
//  Created by Auston Stewart on 1/21/14.
//  Copyright (c) 2014 Justin.tv, Inc. All rights reserved.
//

#import "TWListNavigationController.h"
#import "TwitchKit.h"

@interface TWListNavigationController ()

@end

@implementation TWListNavigationController
{
	UIBarButtonItem *_spaceItem;
	UIBarButtonItem *_portraitCloseButtonItem;
	UIBarButtonItem *_landscapeCloseButtonItem;
}

- (id)initWithRootViewController:(UIViewController *)rootViewController
{
	self = [super initWithRootViewController:rootViewController];
	
	if (self) {
	
		self.modalPresentationStyle = UIModalPresentationFullScreen;
		self.modalTransitionStyle = UIModalTransitionStyleCoverVertical;
		
		// Load the close button
		_spaceItem = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFixedSpace target:nil action:nil];
		_spaceItem.width = [UIDevice currentDevice].isPhone || [UIDevice currentDevice].isRunningOS8 ? -6.f : -10.f;
		_portraitCloseButtonItem = [[UIBarButtonItem alloc] initWithImage:[UIImage imageFromFrameworkBundleNamed:@"glyph_navbar_close_portrait"] style:UIBarButtonItemStylePlain target:self action:@selector(dismissModalListNavigationController)];
		if ([UIDevice currentDevice].isPhone) {
			_landscapeCloseButtonItem = [[UIBarButtonItem alloc] initWithImage:[UIImage imageFromFrameworkBundleNamed:@"glyph_navbar_close_landscape"] style:UIBarButtonItemStylePlain target:self action:@selector(dismissModalListNavigationController)];
		}
		else [self updateCloseButtonForOrientation:[UIApplication sharedApplication].statusBarOrientation];
	}
	
	return self;
}

- (void)dismissModalListNavigationController
{
	[self.presentingViewController dismissViewControllerAnimated:YES completion:^{
		
		// Post a notification
		[[NSNotificationCenter defaultCenter] postNotificationName:TKChannelListingWasDismissedNotification object:self];
	}];
}

- (UIStatusBarStyle)preferredStatusBarStyle
{
	return UIStatusBarStyleLightContent;
}

- (void)viewWillAppear:(BOOL)animated
{
	[super viewWillAppear:animated];
	
	self.navigationBar.translucent = NO;
	self.navigationBar.tintColor = [UIColor whiteColor];
    self.navigationBar.barTintColor = [UIColor twitchPurpleColor];
	self.navigationBar.titleTextAttributes = @{NSFontAttributeName:[UIFont twitchNavigationBarTitleFont],NSForegroundColorAttributeName:[UIColor whiteColor]};
	[self.navigationBar setBackgroundImage:nil forBarPosition:UIBarPositionTopAttached barMetrics:UIBarMetricsDefault];
	[self.navigationBar setShadowImage:nil];
	
	[self updateCloseButtonForOrientation:self.interfaceOrientation];
}

- (void)updateCloseButtonForOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	if (self.viewControllers.count) {
	
		UIBarButtonItem *closeButton = [UIDevice currentDevice].isPad || UIInterfaceOrientationIsPortrait(interfaceOrientation) ? _portraitCloseButtonItem : _landscapeCloseButtonItem;
		
		((UIViewController *)self.viewControllers[0]).navigationItem.leftBarButtonItems = @[_spaceItem,closeButton];
	}
}

- (void)willAnimateRotationToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation duration:(NSTimeInterval)duration
{
	[super willAnimateRotationToInterfaceOrientation:toInterfaceOrientation duration:duration];
	
	if ([UIDevice currentDevice].isPhone)
		[self updateCloseButtonForOrientation:toInterfaceOrientation];
}

@end
